package gov.va.med.mhv.usermgmt.web.converter;

import java.io.Serializable;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.usermgmt.web.formbean.EmergencyContact;

@Component
public class EmergencyContactConverter implements Converter<EmergencyContactDTO, EmergencyContact>, Serializable {
	private static final long serialVersionUID = 1L;

	@Override
	public EmergencyContact convert(EmergencyContactDTO dto) {
		EmergencyContact ec = new EmergencyContact();
		
		ec.setEmergencyContactId(dto.getId());
		ec.setCity(dto.getAddressCity());
		ec.setContactMethod(dto.getContactInfoContactMethod());
		ec.setCountry(dto.getAddressCountry());
		ec.setEmail(dto.getContactInfoEmail());
		ec.setFax(dto.getContactInfoFax());
		ec.setFirstName(dto.getFirstName());
		ec.setHomePhone(dto.getContactInfoHomePhone());
		ec.setLastName(dto.getLastName());
		ec.setMiddleName(dto.getMiddleName());
		ec.setMobilePhone(dto.getContactInfoMobilePhone());
		ec.setPager(dto.getContactInfoPager());
		ec.setPostalCode(dto.getAddressPostalCode());
		ec.setPrimary(dto.getIsPrimary());
		ec.setPriority(dto.getPriority());
		ec.setProvince(dto.getAddressProvince());
		ec.setRelationShip(dto.getRelationship());
		ec.setState(dto.getAddressState());
		ec.setStreet1(dto.getAddressStreet1());
		ec.setStreet2(dto.getAddressStreet2());
		ec.setTitle(dto.getTitle());
		
		ec.setSuffix(dto.getSuffix());
		
		ec.setWorkPhone(dto.getContactInfoWorkPhone());
		ec.setWorkPhoneExt(dto.getContactInfoWorkPhoneExt());
		ec.setUserProfileId(dto.getUserProfileId());
		
		return ec;
	}

}
